"use client";
import {
    AttendenceTabTable,
    ImportDataModal,
    AddStaffModal,
} from "@/ui/components";
import { useState } from "react";
const page = () => {
    const [dataModal, setDataModal] = useState(false);
    const [isAddStaffModalOpen, setIsAddStaffModalOpen] = useState(false);

    function openDataModal() {
        setDataModal(true);
    }
    function closeDataModal() {
        setDataModal(false);
    }

    const openAddStaffModal = () => setIsAddStaffModalOpen(true);
    const closeAddStaffModal = () => setIsAddStaffModalOpen(false);

    return (
        <>
            <div className="content-container staff-content">
                <div className="top-bar">
                    <h4>Shift</h4>
                    <div className="btns-wrapper">
                        <button
                            className="btn btn-outline modal-trigger"
                            onClick={openAddStaffModal}
                        >
                            Add Shift
                        </button>
                        {/* <button
                            className="btn btn-filled modal-trigger"
                            onClick={openDataModal}
                        >
                            <img
                                src="./assets/images/icons/icon-upload.svg"
                                alt="upload icon"
                            />
                            Import Data
                        </button> */}
                    </div>
                </div>
                <AttendenceTabTable />
            </div>
            <ImportDataModal isOpen={dataModal} onClose={closeDataModal} />
            <AddStaffModal
                isOpen={isAddStaffModalOpen}
                onClose={closeAddStaffModal}
            />
        </>
    );
};

export default page;
