"use client";
import { useState } from "react";

const AddStaffModal = ({ isOpen, onClose }) => {
  const [staffData, setStaffData] = useState({
    name: "",
    phone: "",
    salaryPayment: "",
    salary: "",
    shift: "",
    salaryStructure: "",
    salaryCycle: "",
  });

  const handleChange = (e) => {
    const { name, value } = e.target;
    setStaffData({
      ...staffData,
      [name]: value,
    });
  };

  return (
    isOpen && (
      <div className="modal add-staff">
        <div className="modal-content modal-import">
          <img
            src="./assets/images/icons/modal-close.svg"
            className="modal-close-btn close-cross"
            onClick={onClose}
            alt="close"
          />
          <div className="modal-header">
            <div>
              <img src="./assets/images/icons/icon-pencil.png" alt="pencil" />
              <span>Add Staff</span>
            </div>
          </div>
          <div className="sample-file-wrapper">
            <span>Add Staff Details</span>
          </div>
          <form className="form-add-staff">
            <div className="input-wrappers">
              <div className="input-row">
                <label htmlFor="name">Name</label>
                <input
                  type="text"
                  name="name"
                  value={staffData.name}
                  onChange={handleChange}
                  required
                  id="name"
                />
              </div>
              <div className="input-row">
                <label htmlFor="phone">Phone No.</label>
                <input
                  type="tel"
                  name="phone"
                  value={staffData.phone}
                  onChange={handleChange}
                  required
                  id="phone"
                />
              </div>
              <div className="input-row">
                <label htmlFor="salary_payment">Salary Payment</label>
                <select
                  name="salary_payment"
                  id="salary_payment"
                  value={staffData.salaryPayment}
                  onChange={handleChange}
                >
                  <option value="One">One</option>
                  <option value="Two">Two</option>
                  <option value="Three">Three</option>
                </select>
              </div>
              <div className="input-row">
                <label htmlFor="salary">Salary</label>
                <div className="mark-field-wrapper">
                  <input
                    type="text"
                    name="salary"
                    value={staffData.salary}
                    onChange={handleChange}
                    required
                    id="salary"
                  />
                  <span>Per Month</span>
                </div>
              </div>

              <div className="form-staff-divider">
                <img src="./assets/images/icons/arrow-right.svg" alt="right" />
                <span>Advance Option</span>
              </div>

              <div className="input-row">
                <label htmlFor="shift">Shift</label>
                <select
                  name="shift"
                  id="shift"
                  value={staffData.shift}
                  onChange={handleChange}
                >
                  <option value="">Select Shift</option>
                  <option value="Two">Two</option>
                  <option value="Three">Three</option>
                </select>
              </div>

              <div className="input-row">
                <label htmlFor="salary_structure">Salary Structure Temp</label>
                <select
                  name="salary_structure"
                  id="salary_structure"
                  value={staffData.salaryStructure}
                  onChange={handleChange}
                >
                  <option value=""></option>
                  <option value="Two">Two</option>
                  <option value="Three">Three</option>
                </select>
              </div>

              <div className="input-row">
                <label htmlFor="salary_cycle">Salary Cycle</label>
                <select
                  name="salary_cycle"
                  id="salary_cycle"
                  value={staffData.salaryCycle}
                  onChange={handleChange}
                >
                  <option value=""></option>
                  <option value="Two">Two</option>
                  <option value="Three">Three</option>
                </select>
              </div>
            </div>
            <div className="btns-wrapper-modal">
              <button
                className="btn btn-outline modal-close-btn"
                onClick={onClose}
              >
                Cancel
              </button>
              <button className="btn btn-filled">Save</button>
            </div>
          </form>
        </div>
      </div>
    )
  );
};

export { AddStaffModal };
