const attendanceData = [
  {
    name: "Mr. John",
    status: "present",
    date: "22-2-25",
    checkInTime: "08:30 AM",
    checkOutTime: "04:00 PM",
    workingHours: "06:00:00 hrs",
    fine: false,
    lateHours: false,
    overTime: false,
    paidHoliday: false,
  },
  {
    name: "Mr. Tae",
    status: "absent",
    date: "22-2-25",
    checkInTime: "00:00 AM",
    checkOutTime: "00:00 PM",
    workingHours: "00:00:00 hrs",
    fine: true,
    lateHours: false,
    overTime: false,
    paidHoliday: true,
  },
  {
    name: "Mr. Jeon",
    status: "present",
    date: "22-2-25",
    checkInTime: "08:30 AM",
    checkOutTime: "04:00 PM",
    workingHours: "06:00:00 hrs",
    fine: false,
    lateHours: false,
    overTime: "03:30 hrs",
    paidHoliday: false,
  },
];

const UserAttendanceStat = ({ user }) => (
  <div className="user-attendence-stat">
    <div className="details-block">
      <div>
        <h4>{user.name}</h4>
        <span className={`available-status ${user.status}`}>
          {user.status.charAt(0).toUpperCase() + user.status.slice(1)}
        </span>
        <span>{user.date}</span>
      </div>
      <div>
        <img
          src="./assets/images/icons/edit.png"
          className="edit-btn"
          alt="edit"
        />
        <span>Add Note</span>
      </div>
    </div>
    <div className="timeline-block">
      <div className="timmer-wrapper">
        <h4>{user.checkInTime}</h4>
        <h5>Check In</h5>
      </div>
      <div className="working-hours">
        <div className={`linebar-left  ${user.fine ? "bar-red" : ""} `}></div>
        <div className="timmer-wrapper">
          <h4>{user.workingHours}</h4>
          <h5>Working Hours</h5>
        </div>
        <div className={`linebar-right  ${user.fine ? "bar-red" : ""} `}></div>
      </div>
      <div className="timmer-wrapper">
        <h4>{user.checkOutTime}</h4>
        <h5>Check Out</h5>
      </div>
    </div>
    <div className="actions-block">
      <div className="action-cell">{user.fine ? "Fine" : "Fine"}</div>
      <div className="action-cell">
        {user.lateHours ? "Late Hours" : "Late Hours"}
      </div>
      <div className="action-cell">
        {user.overTime ? user.overTime : "03:00"}
      </div>
      <div className={`action-cell ${user.paidHoliday ? "cell-filled" : ""}`}>
        {user.paidHoliday ? "Paid Holiday" : "Paid Holiday"}
      </div>
    </div>
  </div>
);

const AttendanceList = () => {
  return (
    <>
      {attendanceData.map((user, index) => (
        <UserAttendanceStat key={index} user={user} />
      ))}
    </>
  );
};

export { AttendanceList };
