"use client";
import { useState } from "react";
const TabTable = () => {
  const [activeTab, setActiveTab] = useState("All");

  const tableData = [
    {
      id: 1,
      name: "Mr. John",
      phone: "+919024974391",
      amount: "₹ 80,000",
      status: "Active",
      created: "03 April 2024",
    },
    {
      id: 2,
      name: "Mr. Tae",
      phone: "+919024974391",
      amount: "₹ 80,000",
      status: "Active",
      created: "03 April 2024",
    },
    {
      id: 3,
      name: "Mr. Tae",
      phone: "+919024974391",
      amount: "₹ 80,000",
      status: "Active",
      created: "03 April 2024",
    },
    {
      id: 4,
      name: "Mr. Tae",
      phone: "+919024974391",
      amount: "₹ 80,000",
      status: "Active",
      created: "03 April 2024",
    },
    {
      id: 5,
      name: "Mr. Tae",
      phone: "+919024974391",
      amount: "₹ 80,000",
      status: "Active",
      created: "03 April 2024",
    },
    {
      id: 6,
      name: "Mr. Tae",
      phone: "+919024974391",
      amount: "₹ 80,000",
      status: "Active",
      created: "03 April 2024",
    },
    {
      id: 7,
      name: "Mr. Tae",
      phone: "+919024974391",
      amount: "₹ 80,000",
      status: "Not Active",
      created: "03 April 2024",
    },
  ];

  // Filter data based on the selected tab
  const filteredData = tableData.filter((item) => {
    if (activeTab === "All") return true;
    if (activeTab === "Active" && item.status === "Active") return true;
    if (activeTab === "Not Active" && item.status === "Not Active") return true;
    return false;
  });

  return (
    <div className="tab-container">
      {/* Tab Headers */}
      <div className="tab-head">
        <div className="tab-btns-wrapper">
          <span
            className={`tab-btn ${activeTab === "All" ? "tab-active" : ""}`}
            onClick={() => setActiveTab("All")}
          >
            All (07)
          </span>
          <span
            className={`tab-btn ${activeTab === "Active" ? "tab-active" : ""}`}
            onClick={() => setActiveTab("Active")}
          >
            Active (06)
          </span>
          <span
            className={`tab-btn ${
              activeTab === "Not Active" ? "tab-active" : ""
            }`}
            onClick={() => setActiveTab("Not Active")}
          >
            Not Active (01)
          </span>
        </div>
      </div>

      {/* Table Section */}
      <div className="tab-table-wrapper">
        <table>
          <thead>
            <tr>
              <th></th>
              <th>S.No.</th>
              <th>Name</th>
              <th>Phone No</th>
              <th>Amount</th>
              <th>Active</th>
              <th>Created</th>
            </tr>
          </thead>
          <tbody>
            {filteredData.map((row, index) => (
              <tr key={row.id}>
                <td>
                  <input type="checkbox" name={`row-${row.id}`} />
                </td>
                <td>{index + 1}</td>
                <td>{row.name}</td>
                <td>{row.phone}</td>
                <td>{row.amount}</td>
                <td
                  className={row.status === "Active" ? "u-active" : "n-active"}
                >
                  {row.status}
                </td>
                <td>{row.created}</td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>
    </div>
  );
};

export { TabTable };
