"use client";
import Link from "next/link";
import { SideNav } from "..";
import { useState } from "react";
const Header = ({ children }) => {
  const [navOpen, setNavOpen] = useState(false);
  const [searchBar, setSearchBar] = useState(false);
  function toggleNav() {
    setNavOpen(!navOpen);
  }
  const toggleSearchBar = () => setSearchBar(!searchBar);
  return (
    <>
      <header className="header">
        <div className="logo-wrapper">
          <Link href="#">
            <img src="/assets/images/logo.png" alt="logo" />
          </Link>
          <img
            className="hamburger-icon"
            src="/assets/images/icons/hamburger.png"
            alt="hamburger-open"
          />
        </div>
        <div className="header-content-wrapper">
          <img
            className="hamburger-icon hamburger-mobile"
            src="/assets/images/icons/hamburger-close.png"
            alt="hamburger-close"
            onClick={toggleNav}
          />
          <div className="header-content">
            <div className="user-content-container">
              <div className="user-image">
                <img src="/assets/images/user.png" alt="user-image" />
              </div>
              <div className="user-details">
                <h2>Welcome Admin</h2>
                <h4>admin@gmail.com</h4>
              </div>
            </div>
            <div className="search-icons-container">
              <div
                className={`search-bar-wrapper ${
                  searchBar ? "mobile-search-open" : ""
                }`}
              >
                <img
                  src="/assets/images/icons/search-icon.svg"
                  alt="search-icon"
                  className="search-icon"
                />
                <input type="text" name="search" placeholder="Search...." />
                <img
                  src="./assets/images/icons/x-mark.svg"
                  className="close-search"
                  onClick={toggleSearchBar}
                  alt="x-mark"
                />
              </div>
              <div
                className="icon-container search-trigger"
                onClick={toggleSearchBar}
              >
                <img src="/assets/images/icons/search-green.png" alt="search" />
              </div>
              <div className="icon-container">
                <img src="/assets/images/icons/Bell.png" alt="bell" />
              </div>
              <div className="icon-container">
                <img src="/assets/images/icons/Mail.png" alt="mail" />
              </div>
              <Link href="">
                <div className="icon-container">
                  <img src="/assets/images/icons/logout.png" alt="logout" />
                </div>
              </Link>
            </div>
          </div>
        </div>
      </header>
      <div className="content-wrapper">
        <SideNav toggleNav={toggleNav} navOpen={navOpen} />
        {children}
      </div>
    </>
  );
};

export { Header };
